/**
 * \file: gst_drm_audio_dec.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * Decoder for Digital Radio Mondiale (DRM) audio super frames
 *
 * \component: multimedia/gst
 *
 * \author: Bodo Winter ADITG/SW1 bwinter@de.adit-jv.com
 *
 * \copyright: (c) 2003 - 2015 ADIT Corporation
 *
 ***********************************************************************/

#ifndef __GST_DRM_AUDIO_DEC_H__
#define __GST_DRM_AUDIO_DEC_H__

#include "drm_dec_lib.h"

#include <gst/gst.h>
#include <gst/base/gstadapter.h>



G_BEGIN_DECLS

#define GST_TYPE_DRM_DEC \
  (drm_dec_get_type())
#define GST_DRM_DEC(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_DRM_DEC,GstDrmDec))
#define GST_DRM_DEC_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_DRM_DEC,GstDrmDecClass))
#define GST_IS_DRM_DEC(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_DRM_DEC))
#define GST_IS_DRM_DEC_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_DRM_DEC))

typedef struct _GstDrmDec GstDrmDec;
typedef struct _GstDrmDecClass GstDrmDecClass;

#define MAX_CONFIG_SIZE 64

/** \struct AudioConfig
 *  Data object containing the current configuration of incoming GstBuffers.
 */
typedef struct
{
  guint    sampleRate;
  guint    superFrameBytes;
  guint    lengthHigherProtected;
  guint    configSize;
  guint    audioCoding;
  gboolean sbr;
  gboolean drmPlus;
  guint    channels;
  guchar   config[MAX_CONFIG_SIZE];  /* raw SDC - audio info data entity */
} AudioConfig;

/** \struct DecoderConfig
 *  Data object containing the decoder configuration set via GStreamer properties.
 */
typedef struct
{
  guint    concealFadeoutSlope;
  guint    concealFadeinSlope;
  guint    concealFadeMuteRelease;
  guint    concealComfortNoiseLevel;
  gboolean activateUlp;
} DecoderConfig;

/** \struct GstDrmDec
 *  \implements GstElement
 *  \brief Object for decoding DRM audio superframe streams.
 */
struct _GstDrmDec
{
  GstElement element;

  GstPad *sinkpad;
  GstPad *srcpad;

  DRM_DECODER drmDecoder;
  DRMDEC_INFO decInfo;
  DecoderConfig decoderConfig;
  AudioConfig audioConfig;

  GQueue *inputQueue;
  guint bytesValid;
  guint inBufferSize;
  guchar* localInBuffer;

  guint outBufferSize;
  INT_PCM *localOutBuffer;

  gint historySamples;
  guint historyLastFrameOk;
  guint extFrameCount;
  gboolean extFrameCorrupt;
  gboolean isDraining;
};

/** GObject meta class for GstDrmDec */
struct _GstDrmDecClass
{
  GstElementClass parent_class;
};

GType drm_dec_get_type (void);

G_END_DECLS

#endif	/* __GST_DRM_AUDIO_DEC_H__ */
